'use strict';

angular.module('genisis').controller('versionCtrl', ['$scope', 'api', '$window',
  function ($scope, $api, $window) {
    $scope.getAPIVersion = function () {
      return $api.retrieve('/apiversion', {})
        .then(function (apiVersion) {
          $scope.apiVersionNumber = {};
          if (apiVersion.success && apiVersion.response) {
            $scope.apiVersionNumber = apiVersion.response;
          } else {
            $window.alert(apiVersion.message);
          }
        });
    };

    $scope.setUIVersion = function (xml) {
      var xmlDoc = xml.responseXML;
      var version = xmlDoc.getElementsByTagName('version')[0].childNodes[
        0].nodeValue;
      $scope.uiVersionNumber = version;
    };

    $scope.getUIVersion = function () {
      var xmlhttp = new XMLHttpRequest();
      xmlhttp.onreadystatechange = function () {
        if (this.readyState === 4 && this.status === 200) {
          $scope.setUIVersion(this);
        }
      };
      xmlhttp.open('GET', 'pom.xml', true);
      xmlhttp.send();
    };

    $scope.getUIVersion();
    $scope.getAPIVersion();

  }
]);